% Beispiel: Impuls- und Sprungantwort im z-Bereich (Signal Processing Toolbox)
% B.Hartmann, 21.11.2007

% clear all
close all
clc
K = 5;
T = 5;
T0 = 1;                     % Abtastzeit [s]
                              %                          z
Gi = tf([1 0],[1 -0.82],T0) % bertragungsfunktion:  -------
                              %                        z - 0.82 
                              
                              %                          0.9
Gs = tf([0 0.9],[1 -0.82],T0) % bertragungsfunktion:  -------
                              %                        z - 0.82 
                              
G = tf([0 1],[1 0.2])
                              
[gi,ki] = impulse(Gi);           % Sprungantwort des Systems

[gs,ks] = impulse(Gs);           % Sprungantwort des Systems

[g,t] = impulse(G,ks(end));              % Sprungantwort des Systems

%%%%%%%%%%%%%%%
% Darstellung %
%%%%%%%%%%%%%%%

schrift = 12;

figure(1)
hold on
plot(ki,gi,'ro')
plot(ks,gs,'ko')
plot(t,g)
title('Impulsantwort','fontsize',schrift)
xlabel('t [s]','fontsize',schrift)
ylabel('g(t), gi(k*T0), gs(k*T0)','fontsize',schrift,'rotation',90)
legend('Gi','Gs','G','location','NorthEast')
set(gca,'fontsize',schrift,'linewidth',1.5)
hold off